(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     24586,        505]*)
(*NotebookOutlinePosition[     25286,        529]*)
(*  CellTagsIndexPosition[     25242,        525]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(M = {{2, 0, 0, 0}, {0, 2, 0, 0}, {0, 0, 3, 0}, {0, 0, 0, 
          3}}\), "\[IndentingNewLine]", 
    \(B = 
      Table[Table[
          Random[Integer, {0, 6}], {4}], {4}]\), "\[IndentingNewLine]", 
    \(Det[B]\)}], "Input"],

Cell[BoxData[
    \(U = B . M . Inverse[B]\)], "Input"],

Cell[BoxData[
    \(Eigenvalues[U]\)], "Input"],

Cell[BoxData[{
    \(Clear[c0, c1, c2, c3]\), "\[IndentingNewLine]", 
    \(\(Q[z_] = c0 + c1\ z + c2\ z^2 + c3\ z^3;\)\), "\[IndentingNewLine]", 
    \({c0, c1, c2, 
        c3} = {c0, c1, c2, 
          c3} /. \(Solve[{Exp[2  x], x*Exp[2  x], \ Exp[3  x], 
                x*Exp[x]} \[Equal] {Q[2], \(Q'\)[2], Q[3], \(Q'\)[3]}, {c0, 
              c1, c2, c3}]\)[\([1]\)]\)}], "Input"],

Cell[BoxData[
    \(c0*IdentityMatrix[4] + c1\ U + c2\ U . U + c3\ \((U . U)\) . U // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(MatrixExp[U\ x]\)], "Input"],

Cell[BoxData[
    \(% - %% // Simplify\)], "Input"],

Cell[BoxData[
    \(g[c_] := 
      Plot[c*x + 3/c - 2, {x, \(-2\), 2}, 
        DisplayFunction \[Rule] Identity]\)], "Input"],

Cell[BoxData[
    \(<< Graphics`ImplicitPlot`\)], "Input"],

Cell[BoxData[
    \(\(graf = 
        ImplicitPlot[\((y + 2)\)^2 - 12  x \[Equal] 0, {x, 0, 1.5}, 
          PlotStyle \[Rule] {Thickness[ .004], Hue[0]}, Ticks \[Rule] None, 
          Axes \[Rule] None];\)\)], "Input"],

Cell[BoxData[
    \(Show[{Table[g[c], {c, \(-18\), \(-2\), 1}], Table[g[c], {c, 2, 18, 1}], 
        graf}, DisplayFunction \[Rule] $DisplayFunction, 
      PlotRange \[Rule] {{\(-0.5\), 1.5}, {\(-7\), 3}}, 
      AspectRatio \[Rule] 1, Ticks \[Rule] None]\)], "Input"],

Cell[BoxData[
    \(Display["\<envolvente.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(resistencia[p_, q_, n_, \[Lambda]_, opts___] := 
      Module[{punto, medio, vert}, 
        punto[t_] = p + t \((q - p)\)/n; \[IndentingNewLine]medio[t_] = 
          0.5*\((punto[t] + punto[t + 1])\); \[IndentingNewLine]vert[t_] = 
          medio[t] + \((\(-1\))\)^t*\[Lambda]*
              Reverse[punto[t + 1] - punto[t]]*{\(-1\), 
                1}; \[IndentingNewLine]Show[
          Graphics[{opts, Line[{p, vert[0]}], 
              Line[Table[vert[t], {t, 0, n - 1}]], Line[{vert[n - 1], q}]}], 
          Axes \[Rule] None, Ticks \[Rule] None, 
          AspectRatio \[Rule] Automatic, 
          DisplayFunction \[Rule] Identity]]\)], "Input"],

Cell[BoxData[
    \(ClearAll[resistencia]\)], "Input"],

Cell[BoxData[
    \(resistenciaraw[p_, q_, n_, \[Lambda]_, opts___] := 
      Module[{punto, medio, vert}, 
        punto[t_] = p + t \((q - p)\)/n; \[IndentingNewLine]medio[t_] = 
          0.5*\((punto[t] + punto[t + 1])\); \[IndentingNewLine]vert[t_] = 
          medio[t] + \((\(-1\))\)^t*\[Lambda]*
              Reverse[punto[t + 1] - punto[t]]*{\(-1\), 
                1}; \[IndentingNewLine]{opts, Line[{p, vert[0]}], 
          Line[Table[vert[t], {t, 0, n - 1}]], 
          Line[{vert[n - 1], q}]}]\)], "Input"],

Cell[BoxData[
    \(ClearAll[solenoide]\)], "Input"],

Cell[BoxData[
    \(\(solenoide[p_, q_, \[Mu]_:  0.3, opts___] := 
        ParametricPlot[{\((t - \[Pi]/2 + 4 - 
                    4  Sin[t])\) \((q - p)\)[\([1]\)]/\((9  \[Pi] + 
                      8)\), \(-4\)*\[Mu]*Cos[t]} + p, {t, \[Pi]/2, 
            10  \[Pi] - \[Pi]/2}, AspectRatio \[Rule]  .7, 
          DisplayFunction \[Rule] Identity, opts];\)\)], "Input"],

Cell[BoxData[
    \(<< Graphics`Arrow`\)], "Input"],

Cell[BoxData[
    \(\(solenoideraw[p_, q_, \[Mu]_:  0.3, 
          opts___] := \(ParametricPlot[{\((t - \[Pi]/2 + 4 - 
                      4  Sin[t])\) \((q - p)\)[\([1]\)]/\((9  \[Pi] + 
                        8)\), \(-4\)*\[Mu]*Cos[t]} + p, {t, \[Pi]/2, 
              10  \[Pi] - \[Pi]/2}, AspectRatio \[Rule]  .7, 
            DisplayFunction \[Rule] Identity, opts]\)[\([1]\)];\)\)], "Input"],

Cell[BoxData[
    \(\(circuito = 
        Show[Graphics[{Thickness[ .005], Line[{{0, 0}, {0,  .5}}], 
              Line[{{\(- .1\),  .5}, { .1,  .5}}], {Thickness[ .007], 
                Line[{{\(- .07\),  .55}, { .07,  .55}}]}, 
              resistenciaraw[{ .4, 1}, { .7, 1}, 7, 1.4, Thickness[ .006]], 
              Line[{{0,  .55}, {0, 1}, { .4, 1}}], 
              Line[{{ .7, 1}, {1, 1}, {1,  .55}}], 
              Line[{{ .9,  .55}, {1.1,  .55}}], 
              Line[{{ .9,  .5}, {1.1,  .5}}], 
              Line[{{1,  .5}, {1, 0}, { .7, 0}}], Line[{{ .4, 0}, {0, 0}}], 
              solenoideraw[{ .4, 0}, { .7, 0},  .015, 
                PlotStyle \[Rule] Thickness[ .006]]}], 
          DisplayFunction \[Rule] $DisplayFunction, 
          PlotRange \[Rule] All];\)\)], "Input"],

Cell[BoxData[
    \(Display["\<circuito.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(\(circuitodos = 
        Show[{Graphics[{Arrow[{ .1, 1}, { .25, 1}, HeadWidth \[Rule]  .4], 
                Thickness[ .005], Line[{{0, 0}, {0,  .45}}], 
                Line[{{0,  .65}, {0, 1}, { .4, 1}}], 
                Circle[{0, 0.55}, { .07,  .1}], 
                Circle[{\(- .02\),  .55},  .02, {0, Pi}], 
                Circle[{ .02,  .55},  .02, {Pi, 2  Pi}], 
                Line[{{ .7, 1}, {1, 1}, {1,  .55}}], 
                Line[{{ .9,  .55}, {1.1,  .55}}], 
                Line[{{ .9,  .5}, {1.1,  .5}}], 
                Line[{{1,  .5}, {1, 0}, { .7, 0}}], Line[{{ .4, 0}, {0, 0}}], 
                Text[V, { .1,  .55}], Text[R, {0.54,  .88}], 
                Text[L, {0.54,  .13}], Text[i, {0.22,  .92}], 
                Text[C, {0.84,  .53}]}], 
            solenoide[{ .4, 0}, { .7, 0},  .015, 
              PlotStyle \[Rule] Thickness[ .006]], 
            resistencia[{ .4, 1}, { .7, 1}, 7, 1.4, Thickness[ .006]]}, 
          DisplayFunction \[Rule] $DisplayFunction, 
          PlotRange \[Rule] All];\)\)], "Input"],

Cell[BoxData[
    \(Display["\<circuitodos.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"circuitotres", "=", 
        RowBox[{"Show", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{"Graphics", "[", 
                  RowBox[{"{", 
                    
                    RowBox[{\(Arrow[{ .1, 1}, { .25, 1}, 
                        HeadWidth \[Rule]  .4]\), ",", 
                      "\[IndentingNewLine]", \(Arrow[{1.5,  .25}, {1.45,  \
.25}, HeadWidth \[Rule]  .2]\), ",", 
                      "\[IndentingNewLine]", \(Arrow[{2,  .8}, {2,  .65}, 
                        HeadWidth \[Rule]  .2]\), ",", 
                      "\[IndentingNewLine]", \(Arrow[{2, 1.3}, {2, 1.15}, 
                        HeadWidth \[Rule]  .2, HeadLength \[Rule]  .03]\), 
                      ",", "\[IndentingNewLine]", \(Arrow[{ .45, 1.2}, { .55, 
                          1.2}, HeadWidth \[Rule]  .1, 
                        HeadLength \[Rule]  .03]\), ",", 
                      "\[IndentingNewLine]", \(Arrow[{ .45,  .8}, { .55,  \
.8}, HeadWidth \[Rule]  .1, HeadLength \[Rule]  .03]\), ",", 
                      "\[IndentingNewLine]", \(Arrow[{1.1,  .8}, {1.25,  .8}, 
                        HeadWidth \[Rule]  .1, HeadLength \[Rule]  .03]\), 
                      ",", "\[IndentingNewLine]", \(Arrow[{1.05, 1}, {1.15, 
                          1}, HeadWidth \[Rule]  .1, 
                        HeadLength \[Rule]  .03]\), ",", 
                      "\[IndentingNewLine]", \(Arrow[{1.05, 1.4}, {1.15, 
                          1.4}, HeadWidth \[Rule]  .1, 
                        HeadLength \[Rule]  .03]\), ",", 
                      "\[IndentingNewLine]", \(Arrow[{1.83, 1}, {1.95, 1}, 
                        HeadWidth \[Rule]  .1, HeadLength \[Rule]  .03]\), 
                      ",", \(Thickness[ .005]\), ",", "\[IndentingNewLine]", 
                      RowBox[{"Line", "[", 
                        RowBox[{"{", 
                          
                          RowBox[{\({0,  .65}\), ",", \({0, 1}\), 
                            ",", \({ .4, 1}\), ",", \({ .4, 1.2}\), ",", 
                            StyleBox[\({ .6, 1.2}\),
                              FontColor->RGBColor[1, 0, 0]]}], 
                          StyleBox[\( (*solenoide*) \),
                            FontColor->RGBColor[1, 0, 0]], "}"}], "]"}], ",", 
                      "\[IndentingNewLine]", 
                      RowBox[{"Line", "[", 
                        RowBox[{"{", 
                          RowBox[{\({ .8, 1.2}\), ",", 
                            StyleBox[\( (*punto2*) \),
                              FontColor->RGBColor[1, 0, 0]], \({1, 1.2}\), 
                            ",", \({1, 1.4}\), ",", \({1.4, 1.4}\), ",", 
                            StyleBox[\({1.6, 1.4}\),
                              FontColor->RGBColor[1, 0, 0]], 
                            StyleBox[\( (*condensador*) \),
                              FontColor->RGBColor[1, 0, 0]], 
                            StyleBox[",",
                              FontColor->RGBColor[1, 0, 0]], \({1.6, 1.5}\), 
                            ",", \({1.6, 1.3}\)}], "}"}], "]"}], ",", 
                      RowBox[{"Line", "[", 
                        RowBox[{"{", \({1.65, 1.5}, {1.65, 1.3}\), 
                          StyleBox[\( (*condensador*) \),
                            FontColor->RGBColor[1, 0, 0]], "}"}], "]"}], ",", 
                      
                      RowBox[{"Line", "[", 
                        RowBox[{
                        "{", \({1.65, 1.4}, {2, 1.4}, {2, 1}, {1.8, 1}\), 
                          StyleBox[\( (*solenoide*) \),
                            FontColor->RGBColor[1, 0, 0]], "}"}], "]"}], ",", 
                      "\[IndentingNewLine]", 
                      RowBox[{"Line", "[", 
                        RowBox[{"{", 
                          RowBox[{\({1.6, 1}\), ",", 
                            StyleBox[\( (*punto3*) \),
                              FontColor->RGBColor[1, 0, 0]], \({1.5, 1}\), 
                            ",", \({1.4, 1}\)}], 
                          StyleBox[\( (*resistencia*) \),
                            FontColor->RGBColor[1, 0, 0]], "}"}], "]"}], ",", 
                      "\[IndentingNewLine]", \(Line[{{1.2, 1}, {1, 1}, {1, 
                            1.2}}]\), ",", "\[IndentingNewLine]", 
                      RowBox[{"Line", "[", 
                        RowBox[{"{", 
                          StyleBox[\( (*punto4*) \),
                            FontColor->RGBColor[1, 0, 0]], \({2, 
                            1.2}, {2,  .25}, {0,  .25}, {0,  .45}\), "}"}], 
                        "]"}], ",", 
                      "\[IndentingNewLine]", \(Line[{{ .4, 
                            1}, { .4,  .8}, { .8,  .8}, { .8,  .9}, { .8,  \
.7}}]\), ",", \(Line[{{ .85,  .9}, { .85,  .7}, { .85,  .8}, {1.5,  .8}, \
{1.5, 1}}]\), ",", "\[IndentingNewLine]", 
                      RowBox[{"{", 
                        RowBox[{\(Hue[0]\), ",", \(PointSize[ .016]\), ",", 
                          StyleBox[\( (*punto1*) \),
                            FontColor->RGBColor[1, 0, 
                            0]], \(Point[{ .4, 1}]\), 
                          ",", \(Point[{1, 1.2}]\), ",", \(Point[{1.5, 1}]\), 
                          ",", "\[IndentingNewLine]", \(Point[{2, 1}]\)}], 
                        "}"}], ",", \(Circle[{0, 0.55}, { .1,  .1}]\), 
                      ",", \(Circle[{\(- .02\),  .55},  .02, {0, Pi}]\), 
                      ",", \(Circle[{ .02,  .55},  .02, {Pi, 2  Pi}]\), 
                      ",", \(Text[V, { .165,  .55}]\), 
                      ",", \(Text[R, {1.3, 1.12}]\), 
                      ",", \(Text[L, {1.7, 1.12}]\), 
                      ",", \(Text[i1, {0.22,  .92}]\), 
                      ",", \(Text[i2, {0.5, 1.12}]\), 
                      ",", \(Text[i3, {0.5,  .87}]\), 
                      ",", \(Text[i4, {1.09, 1.32}]\), 
                      ",", \(Text[i5, {1.09, 1.07}]\), 
                      ",", \(Text[i6, {1.88, 1.07}]\), 
                      ",", \(Text[i1, {1.4,  .31}]\), 
                      ",", \(Text[C, {1.6, 1.25}]\), 
                      ",", \(Text[P, { .82,  .65}]\), ",", 
                      "\[IndentingNewLine]", \(Text[1, { .46, 1}]\), 
                      ",", \(Text[2, {1.06, 1.2}]\), 
                      ",", \(Text[3, {1.5, 1.06}]\), 
                      ",", \(Text[4, {1.94,  .94}]\), 
                      ",", \(Text[s, { .7, 1.32}]\), 
                      ",", \(Text[m, { .05,  .4}]\), 
                      ",", \(Text[M, { .05,  .7}]\)}], "}"}], "]"}], 
                ",", \(solenoide[{ .6, 1.2}, { .8, 1.2},  .015, 
                  PlotStyle \[Rule] Thickness[ .006]]\), ",", 
                "\[IndentingNewLine]", \(solenoide[{1.6, 1}, {1.8, 1},  .015, 
                  PlotStyle \[Rule] Thickness[ .006]]\), 
                ",", \(resistencia[{1.2, 1}, {1.4, 1}, 7, 1.4, 
                  Thickness[ .006]]\)}], "}"}], 
            ",", \(DisplayFunction \[Rule] $DisplayFunction\), 
            ",", \(PlotRange \[Rule] All\)}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
    \(Display["\<circuitotres.eps\>", circuitotres, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(\(circuitodosnew = 
        Show[{Graphics[{Arrow[{ .1, 1}, { .25, 1}, HeadWidth \[Rule]  .4], 
                Thickness[ .005], Line[{{0, 0}, {0,  .45}}], 
                Line[{{0,  .65}, {0, 1}, { .4, 1}}], 
                Circle[{0, 0.55}, { .07,  .1}], 
                Circle[{\(- .02\),  .55},  .02, {0, Pi}], 
                Circle[{ .02,  .55},  .02, {Pi, 2  Pi}], 
                Line[{{ .7, 1}, {1, 1}, {1,  .55}}], 
                Line[{{ .9,  .55}, {1.1,  .55}}], 
                Line[{{ .9,  .5}, {1.1,  .5}}], 
                Line[{{1,  .5}, {1, 0}, { .7, 0}}], Line[{{1, 0}, {0, 0}}], 
                Text[V, { .1,  .55}], Text[R, {0.54,  .88}], 
                Text[i, {0.22,  .92}], Text[C, {0.84,  .53}]}], 
            resistencia[{ .4, 1}, { .7, 1}, 7, 1.4, Thickness[ .006]]}, 
          DisplayFunction \[Rule] $DisplayFunction, 
          PlotRange \[Rule] All];\)\)], "Input"],

Cell[BoxData[
    \(\(circuitodosnewnew = 
        Show[{Graphics[{Thickness[ .006], \[IndentingNewLine]Line[{{0, 
                      0}, {0,  .5}, { .75,  .5}}],  (*\ \(resistencia[{ .75,  \
.5}, {1.05,  .5}, 8, 1.2, Thickness[ .006]]\)\(,\)*) 
                  Line[{{1.25,  .5}, {1.4,  .5}}], \
\[IndentingNewLine]Circle[{1.5,  .5},  .1], \[IndentingNewLine]Circle[{1.48,  \
.5},  .02, {0, Pi}], \[IndentingNewLine]Circle[{1.52,  .5},  .02, {Pi, 
                    2  Pi}], \[IndentingNewLine]Line[{{1.6,  .5}, {2,  .5}, \
{2, \(- .5\)}}], \[IndentingNewLine]Line[{{0, 0}, { .75, 
                      0}}], \[IndentingNewLine] (*\ \(resistencia[{ .75, 
                      0}, {1.05, 0}, 8, 1.2, 
                    Thickness[ \
.006]]\)\(,\)*) \[IndentingNewLine]Line[{{1.25, 0}, {1.5, 
                      0}}], \[IndentingNewLine] (*\ \(solenoide[{1.5, 
                      0}, {1.7, 0},  .015, 
                    PlotStyle \[Rule] Thickness[ .006]]\)\(,\)*) 
                  Line[{{1.8, 0}, {2, 
                      0}}], \[IndentingNewLine]Line[{{0, \(- .5\)}, { .75, \
\(- .5\)}}],  (*\ \(resistencia[{ .75, \(- .5\)}, {1.05, \(- .5\)}, 8, 1.2, 
                    Thickness[ \
.006]]\)\(,\)*) \[IndentingNewLine]Line[{{1.25, \(- .5\)}, {1.5, \(- .5\)}}], \
\[IndentingNewLine] (*\ \(solenoide[{1.5, \(- .5\)}, {1.7, \(- .5\)},  .015, 
                    PlotStyle \[Rule] Thickness[ .006]]\)\(,\)*) 
                  Line[{{1.8, \(- .5\)}, {2, \(- .5\)}}], \
\[IndentingNewLine]Line[{{0, \(- .5\)}, {0, 
                      0}}], \[IndentingNewLine]Text["\<30\[CapitalOmega]\>", \
{1,  .65}], \[IndentingNewLine]Text["\<110V\>", {1.6,  .65}], \
\[IndentingNewLine]Text["\<10\[CapitalOmega]\>", {1,  .15}], \
\[IndentingNewLine]Text["\<2H\>", {1.6,  .15}], \[IndentingNewLine]Text["\<20\
\[CapitalOmega]\>", {1, \(- .35\)}], \[IndentingNewLine]Text["\<4H\>", {1.6, \
\(- .35\)}], \[IndentingNewLine]Text["\<I\>", {1.92,  .34}], \
\[IndentingNewLine]Text[\*"\"\<\!\(I\_1\)\>\"", { .6,  .06}], \
\[IndentingNewLine]Text[\*"\"\<\!\(I\_2\)\>\"", {1.92, \(- .17\)}], \
\[IndentingNewLine]Arrow[{0,  .5}, { .4,  .5}, HeadWidth \[Rule]  .3], 
                Arrow[{2,  .5}, {2,  .25}, HeadWidth \[Rule]  .3], 
                Arrow[{2, 0}, {2, \(- .25\)}, HeadWidth \[Rule]  .3], 
                Arrow[{ .6, 0}, { .3, 0}, HeadWidth \[Rule]  .3], 
                Arrow[{0, \(- .5\)}, {0, \(- .25\)}, HeadWidth \[Rule]  .3], 
                Arrow[{0, 0}, {0,  .25}, HeadWidth \[Rule]  .3]}], 
            resistencia[{ .75,  .5}, {1.25,  .5}, 8, 1.1, Thickness[ .006]], 
            resistencia[{ .75, 0}, {1.25, 0}, 8, 1.1, Thickness[ .006]], 
            solenoide[{1.5, 0}, {1.8, 0},  .015, 
              PlotStyle \[Rule] Thickness[ .006]], \ 
            resistencia[{ .75, \(- .5\)}, {1.25, \(- .5\)}, 8, 1.1, 
              Thickness[ .006]], 
            solenoide[{1.5, \(- .5\)}, {1.8, \(- .5\)},  .015, 
              PlotStyle \[Rule] Thickness[ .006]]}, 
          DisplayFunction \[Rule] $DisplayFunction, PlotRange \[Rule] All, 
          AspectRatio \[Rule] Automatic, 
          TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] 10}, 
          ImageSize \[Rule]  .75*{351.125, 213.938}];\)\)], "Input"],

Cell[BoxData[
    \(\(Display["\<circuitodosnew.eps\>", 
        circuitodosnewnew, "\<EPS\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(solenoideVert[p_, q_, \[Mu]_:  1/33, opts___] := 
        ParametricPlot[{\(-4\)*\[Mu]*
                Cos[t], \((t - \[Pi]/2 + 4 - 
                    4  Sin[t])\) \((q - p)\)[\([2]\)]/\((9  \[Pi] + 8)\)} + 
            p, {t, \[Pi]/2, 10  \[Pi] - \[Pi]/2}, AspectRatio \[Rule]  .7, 
          DisplayFunction \[Rule] Identity, opts];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[solenoideVert[{1,  .7}, {1,  .4}], 
        DisplayFunction \[Rule] $DisplayFunction];\)\)], "Input"],

Cell[BoxData[
    \(resorte = 
      Show[{Graphics[{{Dashing[{ .01,  .01}], 
                Line[{{\(- .8\), 1.3}, { .5, 1.3}}], 
                Line[{{ .1, 1.1}, { .2, 1.1}, { .2, 1.3}}]}, 
              Arrow[{\(- .225\), 0.7}, {\(- .225\), 2.2}, 
                HeadWidth \[Rule]  .5, HeadLength \[Rule]  .04], 
              Thickness[ .005], Line[{{\(- .75\), 2}, {\(- .3\), 2}}], 
              Line[{{\(- .15\), 2}, { .25, 2}}], Line[{{0, 2}, {0, 1.75}}], 
              Line[{{0, 1.35}, {0, 1.2}, {\(- .1\), 1.2}, {\(- .1\), 
                    1}, { .1, 1}, { .1, 1.2}, {0, 1.2}}], 
              Arrow[{0, 1}, {0, 0.725}, HeadWidth \[Rule]  .5, 
                HeadLength \[Rule]  .04], Text[m, {0, 1.1}], 
              Text[f, {0,  .65}], Text[y, { .4, 1.35}], Text[z, { .25, 1.2}], 
              Text[q, {\(- .5\), 2.1}, {0, 0}], Text[Q, {0, 2.1}, {0, 0}], 
              Line[{{\(- .5\), 2}, {\(- .5\), 1.75}}], 
              Line[{{\(- .5\), 1.55}, {\(- .5\), 1.4}, {\(- .6\), 
                    1.4}, {\(- .6\), 1.2}, {\(- .4\), 1.2}, {\(- .4\), 
                    1.4}, {\(- .5\), 1.4}}]}], 
          solenoideVert[{0, 1.75}, {0, 1.35},  .007, 
            PlotStyle \[Rule] 
              Thickness[ .006]], \[IndentingNewLine]solenoideVert[{\(- .5\), 
              1.75}, {\(- .5\), 1.55},  .007, 
            PlotStyle \[Rule] Thickness[ .006]]}, AspectRatio \[Rule]  .75, 
        PlotRange \[Rule] {{\(- .9\),  .5}, {0.45, 2.2}}]\)], "Input"],

Cell[BoxData[
    \(Display["\<resorte.eps\>", resorte, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Circle[{1.5,  .5},  .1], \[IndentingNewLine]Circle[{1.48,  .5},  .02, \
{0, Pi}], \[IndentingNewLine]Circle[{1.52,  .5},  .02, {Pi, 
        2  Pi}], \)], "Input"],

Cell[BoxData[
    \(\(circuito = 
        Show[Graphics[{Thickness[ .005], 
              Line[{{0, 
                    0}, {0,  .4}}], \[IndentingNewLine]Circle[{0,  .5},  .1], \
\[IndentingNewLine]Circle[{ .03,  .5},  .03, {0, 
                  Pi}], \[IndentingNewLine]Circle[{\(- .03\),  .5},  .03, \
{Pi, 2  Pi}], \[IndentingNewLine]Line[{{0,  .6}, {0,  .72}}], \
\[IndentingNewLine]Line[{{0,  .72}, {\(- .06\),  .82}}], \
\[IndentingNewLine]Line[{{0,  .82}, {0, 1}, { .25, 
                    1}}], \[IndentingNewLine]resistenciaraw[{ .25, 1}, { .5, 
                  1}, 7, 1.3, 
                Thickness[ .005]], \[IndentingNewLine]Line[{{ .5, 1}, { .85, 
                    1}, { .85,  .7}}], \[IndentingNewLine]resistenciaraw[{ \
.85,  .7}, { .85,  .45}, 7, 1.3, 
                Thickness[ .005]], \[IndentingNewLine]Line[{{ .85,  .45}, { \
.85, 0}}], \[IndentingNewLine]Line[{{ .85, 1}, {1.1, 
                    1}}], \[IndentingNewLine]solenoideraw[{1.1, 1}, {1.35, 
                  1},  .015, 
                PlotStyle \[Rule] 
                  Thickness[ .006]], \[IndentingNewLine]Line[{{1.35, 
                    1}, {1.5, 
                    1}, {1.5,  .55}}], \[IndentingNewLine]Line[{{1.35,  .55}, \
{1.65,  .55}}], \[IndentingNewLine]Line[{{1.35,  .5}, {1.65,  .5}}], \
\[IndentingNewLine]Line[{{1.5,  .5}, {1.5, 0}, { .5, 
                    0}}], \[IndentingNewLine]Line[{{ .5, \(- .15\)}, { .5,  \
.15}}], \[IndentingNewLine]Line[{{ .45, \(- .15\)}, { .45,  .15}}], \
\[IndentingNewLine]Line[{{ .45, 0}, {0, 0}}],  (*\ Text[M, { .04,  .66}], 
                Text[m, { .04,  .36}], *)  (*Text[M, {1.44,  .6}], 
                Text[m, {1.44,  .46}], *) \[IndentingNewLine]Text[
                R1, { .37,  .88}], Text[I1, { .62,  .92}], 
              Text[R2, { .7,  .56}], Text[I2, { .92,  .86}], 
              Text[I3, {1.43,  .86}], Text[L, {1.22,  .88}], 
              Text[e, { .18,  .5}], Text[C1, { .47,  .21}], 
              Text[C2, {1.27,  .53}], PointSize[ .02], Point[{ .85, 1}], 
              Point[{ .85, 0}], PointSize[ .012], Point[{\(- .06\),  .82}], 
              Point[{0,  .82}], \[IndentingNewLine] (*\(Arrow[{0,  .6}, {0,  \
.9}, HeadWidth \[Rule]  .23, 
                  HeadLength \[Rule]  \
.05]\)\(,\)*) \[IndentingNewLine]Arrow[{ .55, 1}, { .7, 1}, 
                HeadWidth \[Rule]  .22, 
                HeadLength \[Rule]  .05], \[IndentingNewLine]Arrow[{ .85, 
                  1}, { .85,  .8}, HeadWidth \[Rule]  .22, 
                HeadLength \[Rule]  .05], \[IndentingNewLine]Arrow[{1.5, 
                  1}, {1.5,  .8}, HeadWidth \[Rule]  .22, 
                HeadLength \[Rule]  .05], \[IndentingNewLine]Arrow[{ .85, 
                  0}, { .65, 0}, HeadWidth \[Rule]  .22, 
                HeadLength \[Rule]  .05]}], 
          DisplayFunction \[Rule] $DisplayFunction, PlotRange \[Rule] All, 
          AspectRatio \[Rule] Automatic];\)\)], "Input"],

Cell[BoxData[
    \(\(Display["\<circuito2r2cl.eps\>", %, "\<EPS\>"];\)\)], "Input"]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 249, 6, 124, "Input"],
Cell[2006, 59, 55, 1, 72, "Input"],
Cell[2064, 62, 47, 1, 72, "Input"],
Cell[2114, 65, 387, 7, 202, "Input"],
Cell[2504, 74, 114, 2, 72, "Input"],
Cell[2621, 78, 48, 1, 72, "Input"],
Cell[2672, 81, 51, 1, 72, "Input"],
Cell[2726, 84, 127, 3, 72, "Input"],
Cell[2856, 89, 58, 1, 72, "Input"],
Cell[2917, 92, 220, 4, 98, "Input"],
Cell[3140, 98, 269, 4, 124, "Input"],
Cell[3412, 104, 76, 1, 72, "Input"],
Cell[3491, 107, 677, 12, 250, "Input"],
Cell[4171, 121, 54, 1, 72, "Input"],
Cell[4228, 124, 523, 9, 224, "Input"],
Cell[4754, 135, 52, 1, 72, "Input"],
Cell[4809, 138, 375, 6, 146, "Input"],
Cell[5187, 146, 51, 1, 94, "Input"],
Cell[5241, 149, 401, 6, 172, "Input"],
Cell[5645, 157, 798, 14, 328, "Input"],
Cell[6446, 173, 74, 1, 72, "Input"],
Cell[6523, 176, 1071, 19, 406, "Input"],
Cell[7597, 197, 77, 1, 72, "Input"],
Cell[7677, 200, 7191, 124, 1056, "Input"],
Cell[14871, 326, 89, 1, 72, "Input"],
Cell[14963, 329, 930, 16, 354, "Input"],
Cell[15896, 347, 3284, 52, 1160, "Input"],
Cell[19183, 401, 110, 2, 94, "Input"],
Cell[19296, 405, 374, 6, 124, "Input"],
Cell[19673, 413, 128, 2, 72, "Input"],
Cell[19804, 417, 1478, 24, 488, "Input"],
Cell[21285, 443, 79, 1, 72, "Input"],
Cell[21367, 446, 183, 3, 124, "Input"],
Cell[21553, 451, 2942, 49, 904, "Input"],
Cell[24498, 502, 84, 1, 94, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

